#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Notchs unmandelboxingMod01.fsh   by   Edward 
//https://www.shadertoy.com/view/lsV3Rc
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

uniform vec4 I;

vec3 Z(vec3 p,float a) {
    return vec3(cos(a)*p.y+sin(a)*p.x,cos(a)*p.x-sin(a)*p.y,p.z);
}

float F(vec3 P) {
    float R=sin((iTime+P.z)*.03176)*.45+.5,S=3.4312-sin(iTime*.001);
    vec4 p=vec4(P,1),o=p,s=vec4(S,S,S,abs(S))/R;
    for(int i=0;i<24;i++) {
        if(i==3||i==7||i==11||i==15||i==19||i==23)R=sin(((iTime+P.z)*.01+float(i)*0.25*sin(iTime*.00012211154)*3.8)*3.176)*0.45+0.5;
        p.xyz=clamp(p.xyz,-1.,1.)*2.-p.xyz;
        float r2=dot(p.xyz,p.xyz);
        if(r2>1000.)break;
        p=p*clamp(max(R/r2,R),0.,1.)*s+o;
    }
    return((length(p.xyz)-abs(S-1.))/p.w-pow(abs(S),float(1-24)));
}

float D(vec3 p) {
    vec3 c=vec3(10.,10.,8.);
    p=mod(p,c)-.5*c;
    vec3 q=abs(Z(p,p.z*3.1415/10.*4.));
    float d2=max(q.z-10.,max((q.x*0.866025+q.y*0.5),q.y)-.08);
    p=Z(p,p.z*3.1415/10.*(length(p.xy)-3.)*sin(iTime*.0001)*.8);
    return max(F(p),-d2);
}

vec3 R(vec3 p,vec3 d) {
    float td=0.,rd=0.;
    for(int i=0;i<80;i++) {
        if((rd=D(p))<pow(td,1.5)*.004)break;
        td+=rd;
        p+=d*rd;
    }
    float md=D(p),e=.0025;
    vec3 n=normalize(vec3(D(p+vec3(e,0,0))-D(p-vec3(e,0,0)),D(p+vec3(0,e,0))-D(p-vec3(0,e,0)),D(p+vec3(0,0,e))-D(p-vec3(0,0,e))));
    e*=.5;
    float occ=1.+(D(p+n*.02+vec3(-e,0,0))+D(p+n*.02+vec3(+e,0,0))+D(p+n*.02+vec3(0,-e,0))+D(p+n*.02+vec3(0,e,0))+D(p+n*.02+vec3(0,0,-e))+D(p+n*.02+vec3(0,0,e))-.03)*20.;
    occ=clamp(occ,0.,1.);
    float br=(pow(clamp(dot(n,-normalize(d+vec3(.3,-.9,.4)))*.6+.4, 0.,1.),2.7)*.8+.2)*occ/(td*.5+1.);
    float fog=clamp(1./(td*td*1.8+.4),0.,1.);
    return mix(vec3(br,br/(td*td*.2+1.),br/(td+1.)),vec3(0.,0.,0.),1.-fog);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 f=fragCoord.xy;
    vec3 d=vec3((f-vec2(iResolution/2.))/iResolution.y*2.,1.);
    vec3 c=pow(R(vec3(5.,5.,iTime*.1),normalize(d*vec3(1.,1.,1.-(length(d.xy)*.9)))),vec3(.6,.6,.6));
    //fragColor=vec4(c,1.);
    //fragColor=vec4(pow(floor(c*vec3(8.,8.,4.)+fract(f.x/4.+f.y/2.)/2.)/(vec3(7.,7.,3.)),vec3(1.5,1.5,1.5)),1.);
    vec3 scaledColour = c * vec3(8.,8.,4.);
    //float ditherOffset = 0.;
    float ditherOffset = fract(f.x/4.+f.y/2.)/1.5-.25;
    ditherOffset *= 1.5;
    //float ditherOffset = fract(f.x/2.)/4.+fract(f.y/2.)/2.;
    fragColor=vec4(pow(floor(max(scaledColour+ditherOffset,0.))/vec3(7.,7.,3.),vec3(1.5,1.5,1.5)),1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

